#version 140
#extension GL_EXT_gpu_shader4 : enable
//GPU BossaMod01.fsh by athibaul
//https://www.shadertoy.com/view/tdyfRy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize
uniform sampler2D iChannel0;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

#define texture2D texture2D_Fract

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(512,256,180,120)





// Song: "Favela" by Antonio Carlos Jobim
// Arranged to Shadertoy by Alexis THIBAULT


// Sound design inspired by music programming language SuperCollider
// https://supercollider.github.io/


#define rgb(r,g,b) pow(vec3(r,g,b)/255., vec3(2.2))

// Palette
const vec3 RED = rgb(166,13,54),
	CYAN = rgb(30,183,217),
    TEAL = rgb(28,166,152),
    YELLOW = rgb(242,185,80),
    ORANGE = rgb(242,154,46);


// Raymarching code adapted from my shader "Misty Jungle"
// https://www.shadertoy.com/view/wdcBDH
#define T(p) (textureLod(iChannel0,p,0.).r-0.5)

const float SEA_LEVEL = -0.5;

float smin(float a, float b)
{
	return (a+b - sqrt((a-b)*(a-b)+0.01))/2.;
}

float map(vec3 p)
{
    // Warp coordinates
    p.x += T(p.xy*0.005)*5.;
    p.y += T(p.xy*0.007+0.5)*5.;
    // Add relief
    float d = p.z - 0.1*p.x - T(p.xy*0.1*mat2(.6,.8,-.8,.6))- T(p.xy*0.02)*2.;
    return smin(d, p.z-SEA_LEVEL);
}

float bmap(vec3 p)
{
    return map(p) - T(p.xy*4.*mat2(.6,.8,-.8,.6))*0.01*smoothstep(SEA_LEVEL,SEA_LEVEL+0.1,p.z);
}

vec3 normal( vec3 p, float eps)
{
    vec2 e = eps * vec2(1, -1);
    return normalize(
          e.xxx * bmap(p+e.xxx)
        + e.xyy * bmap(p+e.xyy)
        + e.yxy * bmap(p+e.yxy)
        + e.yyx * bmap(p+e.yyx)
    );
}

float raymarch(vec3 ro, vec3 rd)
{
    float d, t=0.;
    float prev_d, prev_step;
    for(int i=0; i<256;i++)
    {
        d=map(ro+t*rd)*0.5;
        if(t>100.) break;
        if(d<0.001) 
        {
        	t -= d*prev_d/(d-prev_d); 
        	break;
        }
        prev_d = d;
        t += d;
    }
    return t;
}

vec3 render(vec3 ro, vec3 rd, float time)
{
    float t = raymarch(ro, rd);
	vec3 col = vec3(0.0);
    
    
    vec3 skyCol = CYAN + (0.5*rd.y*rd.y);
    vec3 sunCol = vec3(1.0,0.7,0.4);
    // Render surface
    if(t < 100.)
    {
        vec3 p = ro+t*rd;
        float eps = 0.001 + 0.001*t;
        vec3 n = normal(p, eps);
        vec3 sunDir=normalize(vec3(-1,1,2));
        
        // Pick a surface color
        vec3 color = TEAL*0.2; //mix(TEAL, RED, smoothstep(-2.,2.,sin(p.x)+cos(0.6*p.y)));
        
        vec3 green = pow(color, vec3(1.+T(p.xy*0.07))); // Many shades of green
        vec3 surfCol1 = pow(color, vec3(0.4)), // Rocks
            surfCol2 = green;
        // Alternate patches of grass and rocks, with more rocks on slopes
        float grassy = smoothstep(0.2,-0.2,T(p.xy)+1.-n.z*1.2);
        vec3 surfCol = mix(surfCol1, surfCol2, grassy);
        
        // Change surface color if on the beach
        surfCol = mix(surfCol, YELLOW*2.+0.2, smoothstep(0.1, 0.0, p.z-SEA_LEVEL));
        
        vec3 seaCol = TEAL + 0.2*T(p.xy*0.1-cos(time-p.x)*vec2(0.0,0.02)) + 0.2*T(p.yx*0.1-time*vec2(0.05,0));
        seaCol = clamp(seaCol, 0., 1.);
        seaCol = mix(pow(seaCol, vec3(0.4)), seaCol, smoothstep(0.2,-0.2,T(p.xy-0.05*cos(vec2(2,3)*time+p.xy+vec2(1.5,0)))-0.2));
        surfCol = mix(surfCol, seaCol, smoothstep(0.02, 0.01, p.z-SEA_LEVEL));
        //surfCol = seaCol;
        

        // Shade surface
        col += surfCol * 0.4 * (0.5+0.5*n.z) * skyCol;
        col += surfCol * clamp(dot(n, sunDir),0.,1.) * sunCol;
    }
    else
    {
        col = skyCol;
    }
    
    float fog = 1.-exp(-0.01*t);
    col = mix(col, skyCol, fog);
    
    col = max(col, 0.);
    return col;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	float time = iTime*0.5;
    vec2 uv = (2.*gl_FragCoord.xy - iResolution.xy)/iResolution.y;
    vec3 ro = vec3(-3.0-2.*cos(0.2*time),time,0.1-0.3*sin(0.16*time));
    ro.z = max(ro.z, 0.1-map(ro));
    vec3 camFwd = normalize(vec3(sin(0.27*time)*0.3,1,-0.1+0.1*cos(0.4*time)));
    vec3 camRight = normalize(cross(camFwd, vec3(0,0,1)));
    vec3 camUp = cross(camRight, camFwd);
    vec3 rd = normalize(camFwd + 0.5*(uv.x*camRight+uv.y*camUp));
    
    
    vec3 col = render(ro, rd, time);
    
    // Saturate colors
    col *= pow(col/(col.r+col.g+col.b), vec3(dot(uv,uv)*0.3));
    #if 0
    // Basic tone mapping
    col = 1.-exp(-col);
    #else
    // ACES tone mapping
    // https://knarkowicz.wordpress.com/2016/01/06/aces-filmic-tone-mapping-curve/
    // Used in https://www.shadertoy.com/view/ts3Bz7
    col *= 0.9;
    col = (col*(2.51*col+0.03))/(col*(2.43*col+0.59)+0.14);
    #endif
    
    
    col = pow(col, vec3(1./2.2)); // gamma
    gl_FragColor = vec4(col,1.0);
}